<?php
session_start();
include('db.php');

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if user is logged in - corrected to match your session structure
if (!isset($_SESSION['user']) || !isset($_SESSION['user']['user_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.'
    ]);
    exit;
}

$user_id = intval($_SESSION['user']['user_id']); // Get user ID from session

// Get input data
$input = json_decode(file_get_contents("php://input"), true);
$product_id = isset($input['product_id']) ? intval($input['product_id']) : null;
$quantity = isset($input['quantity']) ? intval($input['quantity']) : 1;
$quantity = max(1, $quantity); // Ensure quantity is at least 1

// Validate product ID
if (!$product_id || !is_numeric($product_id)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid product ID.'
    ]);
    exit;
}

// Check if product exists - added error handling
$product_query = "SELECT category, Variant,Selling_price FROM product WHERE Product_id = $product_id AND Delete_status = 0";
$product_result = mysqli_query($conn, $product_query);

if (!$product_result) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . mysqli_error($conn)
    ]);
    exit;
}

if (mysqli_num_rows($product_result) === 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Product not found or unavailable.'
    ]);
    exit;
}

$product = mysqli_fetch_assoc($product_result);
$category_id = $product['category'];
$variant_id = $product['Variant'];
$price = $product['Selling_price'];

// Check if product already in cart - added error handling
$check_query = "SELECT cart_id, Quantity FROM cart WHERE User_id = $user_id AND Product_id = $product_id AND Delete_status = 0";
$check_result = mysqli_query($conn, $check_query);

if (!$check_result) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . mysqli_error($conn)
    ]);
    exit;
}

if (mysqli_num_rows($check_result) > 0) {
    // Update quantity
    $cart_item = mysqli_fetch_assoc($check_result);
    $new_quantity = $cart_item['Quantity'] + $quantity;
    $cart_id = $cart_item['cart_id'];

    $update_query = "UPDATE cart SET Quantity = $new_quantity WHERE cart_id = $cart_id";
    if (mysqli_query($conn, $update_query)) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Product quantity updated in cart.'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to update cart: ' . mysqli_error($conn)
        ]);
    }
} else {
    // Create new cart entry
    $created_date = date('Y-m-d H:i:s');

   

    $insert_query = "INSERT INTO cart ( User_id, Product_id, Category, Variant, Quantity, price, Created_Date, Delete_status)
                     VALUES ($user_id, $product_id,'$category_id', '$variant_id', $quantity, $price, '$created_date', 0)";

    if (mysqli_query($conn, $insert_query)) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Product added to cart successfully.'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to add product to cart: ' . mysqli_error($conn)
        ]);
    }
}

mysqli_close($conn);
?>